#!/bin/sh
#
# Create /var/www/htdocs/bsd.port.mk.html
# this is the target for hyperlinks on a port description
#
# Process the bsd.port.mk man page using man2web,
# then add <a> tags to the Makefile variables;
# handle the few wierd cases using the glob-like names
# with a tool
#

# sed script to force each variable onto it's own line
# (long names already take a whole line)

SHARED=/usr/local/share/portsview

cat <<EOT > /tmp/SX.sed
\\x^     show x,\\x^<span.*>FILESxs/^     \\([A-Z][A-Za-z0-9_-]*\\)  *\\([A-Za-z]\\)/     \\1\\
                   \\2/
EOT

# sed script to decorate most of the Makefile vars with html <a> tags
cat <<EOT > /tmp/SY.sed
\\x^     show x,\\x^<span.*>FILESxs:^     \\([A-Z][A-Za-z0-9_-]*\\) *$:     <A name='\\1'>\\1</A>:
EOT

man2web bsd.port.mk | sed -f /tmp/SX.sed | sed -f /tmp/SY.sed > /tmp/bsd.port.mk.html

# translate MASTER_SITES0, ... MASTER_SITES9 to MASTER_SITES{0,1,2,3,4,5,6,7,8,9}
function translateMasterSites {
	egrep -n '^     MASTER_SITES0' /tmp/bsd.port.mk.html |
		sed -e 's:MASTER_SITE.*:MASTER_SITES{0,1,2,3,4,5,6,7,8,9}:';
}

# translate file glob type names
function translateGlobs {
	egrep -n '^     [A-Z][A-Z_]*\{' /tmp/bsd.port.mk.html | sed -e 'y:\[\]:\{\}:'
}

# syntaxhack.rb generates and decorates strings from syntax specs like: BSD_INSTALL_{PROGRAM,SCRIPT}
function applySyntaxHack {
	(translateMasterSites; translateGlobs) | ruby ${SHARED}/syntaxhack.rb > /tmp/special.sed
}

# insert the <a> tags for the special names
function createTargetFile {
	applySyntaxHack
	sed -f /tmp/special.sed /tmp/bsd.port.mk.html # > /var/www/htdocs/bsd.port.mk.html
}

createTargetFile
