#!/usr/local/bin/ruby

# This program patches sqlports by:
#
# 1. adding and populating a new table 'system_libs' with the names of standard libraries
# 2. adding and populating new column 'category' on the ports table
#
# A copy of the sqlports, named sqlports2.db must have already been created
#

require 'rubygems'
require_gem 'sqlite3-ruby' , '>=1.1.0'

def extractLibname(path)
  a = path.split('/');
  name = a[a.length-1].sub('lib','');
  name
end

  puts " ===> Patching sqlports2.db: this will take a moment"

  db = SQLite3::Database.new( "/usr/local/share/portsview/sqlports2.db" )

  puts ' ===> creating system_libs table'

  db.execute( "create table system_libs(libname text not null, version text not null, section text not null, unique(libname,version));" )

  puts ' ===> adding standard system libs'
  Dir.glob( "/usr/lib/lib*.so.*" ) { |d|
    a = d.split('.')
	libname = extractLibname(a[0])
	version = a[2] + "." + a[3]
	#p libname, version
    db.execute( "insert into system_libs(libname,version,section) values ( ?, ?, ? );", libname, version, 'S' );
  }

  puts ' ===> adding standard X libs'
  Dir.glob( "/usr/X11R6/lib/lib*.so.*" ) { |d|
    a = d.split('.')
	libname = extractLibname(a[0])
	version = a[2] + "." + a[3]
	#p libname, version
    db.execute( "insert into system_libs(libname,version,section) values ( ?, ?, ? );", libname, version, 'X' );
  }

  puts ' ===> altering ports table to add column'

  db.execute( "alter table ports add column category text" )

  puts ' ===> updating categories'
  db.execute( "select * from ports" ).each do |row|
    a = row[0].split('/')
    db.execute( "update ports set category = ? where fullpkgpath = ?", a[0], row[0] )
  end

  puts " ===> That's all, folks!"
