#!/usr/local/bin/ruby
# process the lines presented on stdin which must have the form:
# <lineno>:<glob-like name>
# the glob-like name has the format:
# text{segment,segment,...}moretext{segment,setment,...}yetmoretext.etc
#

## generate strings from specification
#    strings - array of strings specified reading from left to right
#    parts - array of text and segments
#    pos - current position, working from left to right in the spec
#
def generate(strings,parts,pos)
#  p strings
#  p parts
#  p pos
  if pos < parts.length then
    part = parts[pos];
#	p part;
    strings2 = [];
    if part =~ /^\{/ then
	  items = part.gsub(/[{}]/,"").split(",");
#	  p items
	  strings.each { |s| items.each { |t| strings2 = strings2 << "#{s}#{t}" } }
	else
	  strings.each { |s| strings2 = strings2 << "#{s}#{part}" }
	end
    generate(strings2,parts,pos+1);
  else
    strings
  end
end

## returns the variants from the specification in the given line
def variants(line)
  parts = (line.gsub(/[{}]/) { |c| if c == '{' then "/#{c}" else "#{c}/" end }).split("/");
  generate([""],parts,0);
end

## decorate the items in the array by adorning them with <a> tags
def decorate(array)
  array.each_index { |i| s = array[i].sub(/ */,"").chomp; array[i] = "     <A name='#{s}'/>\\\n" }
  array
end

while line = gets
  a = line.split(":");
  puts "#{a[0]}i\\";
  puts decorate(variants(a[1]));
  puts ""
end
