# $OpenBSD: java.port.mk,v 1.3 2005/07/14 17:29:58 kurt Exp $

# Adapted from devel/jdk/java.port.mk
# Getting here depends on the setting of MODJAVA_PROVIDER
# by which the user indicates the prefered java build environment
# See /usr/ports/infrastructure/mk/java.port.mk
# leaving MODJAVA_PROVIDER unset begets a warning and default to Sun JDK

# Set MODJAVA_VER to x.y or x.y+ based on the version
# of the jdk needed for the port. x.y  means any x.y jdk.
# x.y+ means any x.y jdk or higher version. Valid values
# for x.y are 1.3, 1.4 or 1.5.

MODJAVA_VER?=

# Set MODJAVA_JRERUN=yes if the port can run with just
# the jre. This will add the jre's to the RUN_DEPENDS
# based on how MODJAVA_VER is set.

MODJAVA_JRERUN?=no

# Based on the MODJAVA_VER, MODJAVA_JRERUN, NO_BUILD
# and MACHINE_ARCH, the following things will be setup:
#   ONLY_FOR_ARCHS if not already set.
#   BUILD_DEPENDS on a jdk (native preferred).
#   JAVA_HOME to pass on to the port build.
#   RUN_DEPENDS for all jdk's and jre's that can run
#   the port.

.if ${MODJAVA_VER:S/+//} == "1.3" || ${MODJAVA_VER:S/+//} == "1.4"
ONLY_FOR_ARCHS?=	i386
JAVA_HOME=		${LOCALBASE}/exodus
BUILD_DEPENDS+=		:jamvm->=1.4.1:lang/jamvm
RUN_DEPENDS+= :exodus->=0.1:devel/exodus
.else
ERRORS+="Fatal: MODJAVA_VER must be set to a valid value for jamjdk"
.endif
