# Set MODJAVA_PROVIDER to the name of the "JDK Provider"
#
# The ones we know:
#
#   sunjdk -- Sun's code under SDLC
#     set MODJAVA_VER to one of the version 1.3, 1.4, 1.5
#
#   exodus -- free tools based on gnu classpath and jamvm, basically j2sdk 1.4.2
#      set MODJAVA_VER to something other than 1.5

#   Default to sunjdk if not set
#


MODJAVA_PROVIDER?= sunjdk

.if ${MODJAVA_PROVIDER:L} == "exodus"
.include "${PORTSDIR}/devel/exodus/java.port.mk"
.elif ${MODJAVA_PROVIDER:L} == "sunjdk"
.include "${PORTSDIR}/devel/jdk/java.port.mk"
.else
ERRORS+= "Fatal: MODJAVA_PROVIDER not set to a known JDK provider name"
.endif
