package com.druseikis.tests.threads;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ThreadMeister {

	ArrayList workers;
	List counters;

	public static void main(String[] args) {
		int nThreads = 0;
		int maxCapacity = 0;
		if( args.length == 0 ) {
			nThreads = 5;
		} else if( args.length >= 0 ) {
			nThreads = Integer.parseInt(args[0]);
			if( args.length >= 1 ) {
				maxCapacity = Integer.parseInt(args[1]);
			}
		}
		if( nThreads <= 0 || maxCapacity <= 0 ) {
			throw new IllegalArgumentException(
				"usage: com.druseikis.tests.threads.ThreadMeister nThreads(>0) maxCapacity(>0)");
		}
		System.out.println("Hello world!");
		new ThreadMeister().go(nThreads,maxCapacity);
	}

	private void go(int nThreads, int capacity) {
		counters = Collections.synchronizedList( new ArrayList(nThreads) );
		workers = new ArrayList(nThreads);
		for( int i=0; i<nThreads; i++ ) {
			workers.add(new Worker(i,"Worker: " + i,capacity));
		}
		System.out.println("Starting ...");
		for( int i=0; i<nThreads; i++ ) {
			counters.add(null);
			System.out.print(' ');
			System.out.print(i);
			((Thread)workers.get(i)).start();
		}
		System.out.println();
		System.out.println("Reporting ...");
		for(;;) {
			try {
				Thread.sleep(5000);
			} catch( InterruptedException e ) {
				System.out.print("*");
			}
			for( int i=0; i<nThreads; i++ ) {
				System.out.print(" ");
				System.out.print( counters.get(i) );
			}
			System.out.println();
		}
	}

	class RandomException extends Exception {

	}

	private synchronized void writeMyIndex(int index) {
		System.err.print(' ');
		System.err.print(index);
	}

	private int count = 0;

	private synchronized void maybeForceNewLine() {
		if( count % 10 == 0 )
			System.err.println();
		count++;
	}

	private synchronized void writeExceptionMarker() {
		System.err.print(" *");
	}

	class Worker extends Thread implements Runnable {
		int myIndex;
		String myName;
		ArrayList myObjects;
		int capacity;
		int count;

		Worker(int index, String name, int capacity) {
			myIndex = index;
			myName = name;
			this.capacity = capacity;
			myObjects = new ArrayList(capacity);
			for( int i=0; i<capacity; i++ ) {
				myObjects.add(null);
			}	
		}

		private void explode(int depth, boolean throwIt ) throws RandomException {
			if( depth > 0 )
				explode(depth-1,throwIt);
			if( throwIt )
				throw new RandomException();
		}

		public void run() {
			int explosions = 0;
			for( count=0; true; count++) {
				StringBuffer buffer = new StringBuffer();
				buffer.append(myName);
				buffer.append(':');
				buffer.append(count);
				myObjects.set( count % capacity, buffer.toString() );
				try {
					int n = (int) (100.0*Math.random());
					explode( n/25, n < 10 );
				} catch( RandomException e ) {
					explosions++;
					counters.set(myIndex,new Integer(explosions));
					writeExceptionMarker();
				}
				writeMyIndex(myIndex);
				maybeForceNewLine();
			}
		}
	}
}
