#include "config.h"
#include "private/gc_priv.h"

#if defined(GC_OPENBSD_PTHREADS) 

#include <stdio.h>
#include <sys/signal.h>
#include <pthread_np.h>

#undef GLOBAL_PTHREAD_PRIVATE
#include "pthread_private.h"

GC_bool GC_thr_initialized = 0;

volatile unsigned int GC_allocate_lock = 0;
volatile GC_bool GC_collecting = 0;

extern ptr_t GC_find_limit(ptr_t p, GC_bool up);

#ifdef DEBUG_THREADS
#define	DEBUG_GC_printf0(a)	GC_printf0(a)
#define	DEBUG_GC_printf1(a,b)	GC_printf1(a,b)
#define	DEBUG_GC_printf3(a,b,c,d)	GC_printf3(a,b,c,d)
#else
#define	DEBUG_GC_printf0(a)
#define	DEBUG_GC_printf1(a,b)
#define	DEBUG_GC_printf3(a,b,c,d)
#endif

void GC_stop_world()
{
	DEBUG_GC_printf0("[GC_stop_world]\n");
	pthread_suspend_all_np();
}

void GC_start_world()
{
	DEBUG_GC_printf0("[GC_start_world]\n");
	pthread_resume_all_np();
}

extern void GC_push_all(ptr_t bot, ptr_t top);

static void GC_push_all_stacks_inner(pthread_t pthread)
{
	ptr_t lo, hi;
	struct sigaltstack stack;
	if( pthread_stackseg_np( pthread, &stack ) ) {
		ABORT("pthread_stackseg_np");
	}
	if( pthread->sig_saved ) {
		lo = (ptr_t) pthread->saved_sigcontext.sc_esp;
	} else {
		lo = (ptr_t) pthread->_machdep.esp;
	}
	if( pthread_equal( pthread_self(), pthread ) ) {
		lo = (ptr_t) &lo;
	}
	if( lo == 0 ) {
		ABORT("lo == 0 -- stack bottom undefined");
	}
	hi = GC_find_limit(lo,1);
	DEBUG_GC_printf3("GC_push_all_stacks_inner pthread 0x%x lo=0x%x, hi=0x%x\n",pthread,lo,hi);
	GC_push_all(lo,hi);
}

void GC_push_all_stacks()
{
	pthread_t that;
	DEBUG_GC_printf0("[GC_push_all_stacks]\n");
	TAILQ_FOREACH(that, &_thread_list, tle) {
#ifdef DEBUG_THREADS
		if( (that->flags & PTHREAD_FLAGS_PRIVATE) == 0 ) {
			DEBUG_GC_printf1("GC_push_all_stacks 0x%x\n", that );
		} else {
			DEBUG_GC_printf1("GC_push_all_stacks 0x%x PTHREAD_FLAGS_PRIVATE\n", that );
		}
#endif
		if( (that->flags & PTHREAD_FLAGS_PRIVATE) == 0 ) {
			GC_push_all_stacks_inner(that);
		}
	}
}

void GC_thr_init()
{
	DEBUG_GC_printf0("[GC_thr_init]\n");
    GC_thr_initialized = 1;
}

pthread_mutex_t GC_allocate_ml = PTHREAD_MUTEX_INITIALIZER;

void GC_lock()
{
	DEBUG_GC_printf0("[GC_lock]\n");
	pthread_mutex_lock(&GC_allocate_ml);
}

void GC_push_thread_structures()
{
	DEBUG_GC_printf0("[GC_push_thread_structures]\n");
}

int GC_pthread_create(pthread_t *new_thread,
		const pthread_attr_t *attr,
		void *(*start_routine)(void *), void *arg)
{
#undef pthread_create
	DEBUG_GC_printf0("[GC_pthread_create]\n");
	return pthread_create(new_thread,attr,start_routine,arg);
}

/* Added for cacao */
/* These signals are not used in openbsd */

int GC_signum1()
{
	DEBUG_GC_printf0("[GC_signum1]\n");
    return SIG_SUSPEND;
}

int GC_signum2()
{
	DEBUG_GC_printf0("[GC_signum2]\n");
    return SIG_THR_RESTART;
}

/* cacao END */

#endif /* GC_OPENBSD_THREADS */
